/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.recipe.serializer;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import javax.annotation.Nonnull;
import mekanism.api.SerializerHelper;
import mekanism.api.recipes.CombinerRecipe;
import mekanism.api.recipes.ingredients.ItemStackIngredient;
import mekanism.api.recipes.ingredients.creator.IngredientCreatorAccess;
import mekanism.common.Mekanism;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class CombinerRecipeSerializer<RECIPE extends CombinerRecipe>
extends ForgeRegistryEntry<RecipeSerializer<?>>
implements RecipeSerializer<RECIPE> {
    private final IFactory<RECIPE> factory;

    public CombinerRecipeSerializer(IFactory<RECIPE> factory) {
        this.factory = factory;
    }

    @Nonnull
    public RECIPE fromJson(@Nonnull ResourceLocation recipeId, @Nonnull JsonObject json) {
        JsonArray mainInput = GsonHelper.m_13885_((JsonObject)json, (String)"mainInput") ? GsonHelper.m_13933_((JsonObject)json, (String)"mainInput") : GsonHelper.m_13930_((JsonObject)json, (String)"mainInput");
        ItemStackIngredient mainIngredient = (ItemStackIngredient)IngredientCreatorAccess.item().deserialize((JsonElement)mainInput);
        JsonArray extraInput = GsonHelper.m_13885_((JsonObject)json, (String)"extraInput") ? GsonHelper.m_13933_((JsonObject)json, (String)"extraInput") : GsonHelper.m_13930_((JsonObject)json, (String)"extraInput");
        ItemStackIngredient extraIngredient = (ItemStackIngredient)IngredientCreatorAccess.item().deserialize((JsonElement)extraInput);
        ItemStack output = SerializerHelper.getItemStack(json, "output");
        if (output.m_41619_()) {
            throw new JsonSyntaxException("Combiner recipe output must not be empty.");
        }
        return this.factory.create(recipeId, mainIngredient, extraIngredient, output);
    }

    public RECIPE fromNetwork(@Nonnull ResourceLocation recipeId, @Nonnull FriendlyByteBuf buffer) {
        try {
            ItemStackIngredient mainInput = (ItemStackIngredient)IngredientCreatorAccess.item().read(buffer);
            ItemStackIngredient extraInput = (ItemStackIngredient)IngredientCreatorAccess.item().read(buffer);
            ItemStack output = buffer.m_130267_();
            return this.factory.create(recipeId, mainInput, extraInput, output);
        }
        catch (Exception e) {
            Mekanism.logger.error("Error reading combiner recipe from packet.", (Throwable)e);
            throw e;
        }
    }

    public void toNetwork(@Nonnull FriendlyByteBuf buffer, @Nonnull RECIPE recipe) {
        try {
            ((CombinerRecipe)recipe).write(buffer);
        }
        catch (Exception e) {
            Mekanism.logger.error("Error writing combiner recipe to packet.", (Throwable)e);
            throw e;
        }
    }

    @FunctionalInterface
    public static interface IFactory<RECIPE extends CombinerRecipe> {
        public RECIPE create(ResourceLocation var1, ItemStackIngredient var2, ItemStackIngredient var3, ItemStack var4);
    }
}

